package org.amse.mm.myTest;

import junit.framework.TestCase;
import org.amse.mm.myVirtualBilliards.model.*;
import org.amse.mm.myVirtualBilliards.model.impl.*;

public class TestStatic extends TestCase{
	public void test1(){
		ITable table = new Table();
		IBall ball1 = table.addBall(10, 10, BallColor.BLACK);
		IBall ball2 = table.addBall(20, 10, BallColor.BLUE);
		assertNotNull(ball1);
		assertNull(ball2);
	}
	
	public void test2(){
		ITable table = new Table();
		IBall ball = table.addBall(-10, 50, BallColor.RED);
		assertNull(ball);
	}
	
	public void test3(){
		ITable table = new Table();
		IBall ball = table.addBall(10, 50, BallColor.BLACK);
		assertEquals(ball.getColor(), BallColor.BLACK);	
	}
	
	public void test4(){
		ITable table = new Table();
		IBall ball1 = table.addBall(100, 100, BallColor.BLACK);
		IBall ball2 = table.addBall(20, 10, BallColor.BLACK);
		assertNotNull(ball1);
		assertNull(ball2);
	}
	
	public void test5(){
		ITable table = new Table();
		IBall ball = table.addBall(100, 100, BallColor.BLACK);
		assertTrue(table.balls().contains(ball));
	}
	
	public void test6(){
		ITable table = new Table();
		table.addBall(10, 10, BallColor.BLACK);
		table.addBall(40, 10, BallColor.BLUE);
		assertEquals(table.balls().size(), 2);
	}
	
	public void test7(){
		ITable table = new Table();
		IBall ball = table.addBall(10, 10, BallColor.BLACK);
		table.deleteBall(ball);
		assertTrue(table.balls().isEmpty());
	}
	
	public void test8(){
		ITable table = new Table();
		IBall ball = table.addBall(10, 10, BallColor.BLACK);
		assertEquals(ball.getColor(), BallColor.BLACK);
	}
	
	public void test9(){
		ITable table = new Table();
		IBall ball = table.addBall(10, 10, BallColor.BLACK);
		assertEquals(ball.getCoordinate().X, 10.0);
	}
	
	public void test10(){
		ITable table = new Table();
		IBall ball = table.addBall(50, 110, BallColor.BLACK);
		assertEquals(ball.getCoordinate().Y, 110.0);
	}
	
	public void test11(){
		ITable table = new Table();
		assertTrue(table.balls().isEmpty());
	}
	
	public void test12(){
		ITable table = new Table();
		IBall ball = table.addBall(50, 110, BallColor.BLACK);
		ball.setCoordinate(10, 10);
		assertEquals(ball.getCoordinate().X, 10.0);
	}
	
	public void test13(){
		ITable table = new Table();
		IBall ball = table.addBall(50, 110, BallColor.BLACK);
		ball.setCoordinate(160, 106);
		assertEquals(ball.getCoordinate().Y, 106.0);
	}
	
	public void test14(){
		ITable table = new Table();
		IBall ball = table.addBall(50, 110, BallColor.BLACK);
		table.deleteBall(ball);
		assertTrue(table.balls().isEmpty());
	}
	
	public void test15(){
		ITable table = new Table();
		IBall ball = table.addBall(10, -50, BallColor.RED);
		assertNull(ball);
	}
	
	public void test16(){
		ITable table = new Table();
		IBall ball = table.addBall(50, 110, BallColor.BLACK);
		ball.setVelocity(10, 10);
		assertEquals(ball.getVelocity().VX, 10.0);
	}
	
	public void test17(){
		ITable table = new Table();
		IBall ball = table.addBall(50, 110, BallColor.BLACK);
		ball.setVelocity(10, 10);
		assertEquals(ball.getVelocity().VY, 10.0);
	}

}
